#! /system/bin/busybox sh
. /system/bin/common.sh
if [ $# -eq 3 ] ; then
     printf "Export aborted- No arguments supplied to export script"
     exit 1
fi
UiPrintFD=$1
CMD=$2
TMP_CERT="/tmp/backup_cert.tar"

reset(){
	busybox dd if=/dev/zero of=/dev/block/mmcblk0p6 bs=1M count=5
}

backup(){
	$mkdir -p /cert
	$mount -t ext4 /dev/block/mmcblk0p5 /cert
	check_is_mounted "/cert"
	ui_print "Backup content of certifcate partition to tmp folder"
	cd /cert
	$tar -cf ${TMP_CERT} *
	cd /
	$umount /cert
}

restore(){
	$mount -t ext4 /dev/block/mmcblk0p5 /cert
	check_is_mounted "/cert"
	ui_print "RESTORE content of certifcate partition from tmp folder"
	$tar -xf ${TMP_CERT} -C /cert
	$umount /cert
}

case "$2" in
	backup)
		backup
		;;
	restore)
		restore
		;;
	*)
		ui_print $"Usage: $2 {backup|restore}"
		exit 1;
		;;
esac

exit 0
